function X = mninverse(U, mu, sigma, mix)

    G = (-10: 0.01: 10)';
    F = mix*normcdf(G, mu(1), sigma(1)) + (1-mix)*normcdf(G, mu(2), sigma(2));
    D = F(2: end) - F(1: end-1);
    
    X = zeros(size(U));
    for i = 1: size(U, 1)
        for j = 1: size(U, 2)
            idx = 1;
            while F(idx+1) < U(i, j)
                idx = idx + 1;
            end
            X(i, j) = G(idx) + 0.01*(U(i, j) - F(idx))/D(idx);
        end
    end
            